<?php

class API
{
    private false|\CurlHandle $ch;

    public function __construct()
    {
        $time = 60 * 3;
        ini_set('max_execution_time', $time);
        set_time_limit($time);
    }

    public function makeRequest($method): \CurlHandle|bool
    {
        $this->ch = curl_init(\Config::API_URL . $method);
        curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($this->ch, CURLOPT_HEADER, false);
        curl_setopt($this->ch, CURLOPT_FOLLOWLOCATION, true);

        return $this->ch;
    }

    public function POST($data)
    {
        $payload = json_encode($data);

        curl_setopt($this->ch, CURLOPT_HTTPHEADER, [
            'Accept: application/json',
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload)
        ]);

        curl_setopt($this->ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($this->ch, CURLOPT_POST, true);
        curl_setopt($this->ch, CURLOPT_POSTFIELDS, $payload);
        return $this;
    }

    public function importPlatforms($data)
    {

        $this->makeRequest('/dataImport/platforms');
        $data['token'] = Config::API_TOKEN;

        $this->POST($data);

        curl_setopt($this->ch,CURLOPT_CUSTOMREQUEST, 'PATCH');

        $result = $this->exec($info);

        if ($info['http_code'] != 200) {
            dd([
                'ERROR IMPORT PLATFORMS',
                $info,
                json_decode($result, 1)
            ]);
            return false;
        }
        return $result;
    }

    public function importProducts($data)
    {
        $this->makeRequest('/dataImport/products');
        curl_setopt($this->ch, CURLOPT_CUSTOMREQUEST, 'PATCH');

        $data['token'] = Config::API_TOKEN;
        $this->POST($data);


        $result = $this->exec($info);
        file_put_contents('APIresult.html', $result);

        if ($info['http_code'] != 200) {
            $jsonDecoded = json_decode($result, 1);
            dd([
                'ERROR IMPORT PRODUCTS',
                $info,
                ($jsonDecoded == NULL ? $result : $jsonDecoded)
            ]);
            return false;
        }
        return $result;
    }

    public function exec(&$info, $close = true)
    {
        $result = curl_exec($this->ch);
        $info = curl_getinfo($this->ch);
        if ($close)
            curl_close($this->ch);

        return $result;
    }
}