<?php

require_once __DIR__ . '/library/parser/bootstrap.php';

use library\API;
use library\Parser;

error_reporting(E_ALL);
ini_set('log_errors', true);
ini_set('error_log', __DIR__ . '/php_error.log');
ini_set('display_errors', 1);
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 60 * 3);
set_time_limit(60 * 3);


$p = new Parser();
$api = new API();
$m = new \library\Model();

$products = $m->getNotParsedProducts(Config::PARSE_PRODUCTS_THREADS);
$products = $p->getProducts($products);
$downloadImages = [];

foreach ($products as $prod) {

    if(!$prod['data']['item'])
        continue;

    foreach ($prod['data']['item']['attachments'] as $fileKey => $file) {

        $url = parse_url($file['url']);
        $fileName = /*create_token(6) . '_' .*/
            $prod['id'] . '_' . $fileKey . '.' . pathinfo($file['url'], PATHINFO_EXTENSION);

        $downloadImages[] = [
            'url' => $file['url'],
            'filename' => $fileName,
            'savePath' => Config::PRODUCT_IMAGES_PATH . '/' . $fileName
        ];
    }
}

$p->downloadImages($downloadImages, true);

$apiResult = $api->importProducts([
    'products' => $products
]);

echo json_encode($products);
