<?php
class Parser
{
    private const GRAPH_URI = 'https://playerok4.com/graphql';
    private Model $m;
    private $proxy_key = 0;

    public function __construct()
    {
        $this->m = new Model();
    }

    public function makeRequest(string $URL): CURL
    {

        $curl = new CURL($URL, false);
        $curl->set_opt(CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
        $curl->set_opt(CURLOPT_SSL_VERIFYPEER, false);
        $curl->set_opt(CURLOPT_SSL_VERIFYHOST, false);
        $curl->set_opt(CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_3);

        if (count(Config::PROXY_LIST)) {

            $proxy = Config::PROXY_LIST[$this->proxy_key];

            $curl->set_opt(CURLOPT_PROXY, $proxy['host']);
            $curl->set_opt(CURLOPT_PROXYTYPE, $proxy['type']);

            if (isset($proxy['pass']) && $proxy['pass']) {
                $curl->set_opt(CURLOPT_PROXYAUTH, CURLAUTH_BASIC);
                $curl->set_opt(CURLOPT_PROXYUSERPWD, $proxy['login'] . ':' . $proxy['pass']);
            }
            $this->proxy_key++;
            if($this->proxy_key >= count(Config::PROXY_LIST))
                $this->proxy_key = 0;
        }


        $curl->set_opt(CURLOPT_HTTPHEADER, [
            'Accept-Language: ru-RU,ru;q=0.9,en-US;q=0.8,en;q=0.7',
            'Content-Type: application/json',
        ]);
        $curl->set_opt(CURLOPT_REFERER, 'https://playerok4.com/');
        $curl->set_opt(CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0');
        return $curl;
    }

    public function getPlatforms($count = 3, $after = '')
    {



        $data = [
            "operationName" => "games",
            "variables" => json_encode([
                "pagination" => [
                    "first" => $count,
                    'after' => $after ? $after:null
                ],
                "filter" => [
//                    "type" => "GAME"
                ]
            ],JSON_FORCE_OBJECT),
            "extensions" => json_encode([
                "persistedQuery" => [
                    "version" => 1,
                    "sha256Hash" => "b9f6675fd5923bc5c247388e8e3209c3eede460ed328dbe6a9ec8e6428d3649b"
                ]
            ],JSON_FORCE_OBJECT),
//            "query" => file_get_contents(dirname(__DIR__) . '/queries/getPlatformsQuery.txt')
        ];



        $curl = $this->makeRequest(self::GRAPH_URI . '?' . http_build_query($data));
        $jsonResult = $curl->exec(false, $info);
        $curlErrors = curl_error($curl->ch);
        curl_close($curl->ch);

        if ($curlErrors || $info['http_code'] != 200) {
            dd(curl_error($curl->ch));
            dd($info);
        } else {
            return json_decode($jsonResult, 1);
        }
        return false;
    }

    public function getItems($count = 1, $after = '')
    {
        $curl = $this->makeRequest(self::GRAPH_URI);

        $data = [
            "operationName" => "items",
            "variables" => [
                "pagination" => [
                    "first" => $count
                ],
                "filter" => [
//                    "attributes" => [],
//                    'gameCategoryId' => "1ecc48ce-52e6-6010-c327-d8c26efee5e3",
//                    'gameId' => "1ecc48ce-4f1a-6531-300d-9faaa8c3ab04",
                    'status' => ['APPROVED'],
                ]
            ],
            "query" => file_get_contents(dirname(__DIR__) . '/queries/getItemsQuery.txt')
        ];

        if ($after) {
            $data['variables']['pagination']['after'] = $after;
        }

        $curl->set_opt(CURLOPT_POST, 1);
        $curl->set_opt(CURLOPT_POSTFIELDS, json_encode($data));

        $jsonResult = $curl->exec(false, $info);
        $curlErrors = curl_error($curl->ch);
        curl_close($curl->ch);

        if ($curlErrors || $info['http_code'] != 200) {
            dd(curl_error($curl->ch));
            dd($info);
        } else {
            return json_decode($jsonResult, 1);
        }

        return false;
    }

    public function getProducts(array $items = []): array
    {

        $mc = new CURL;
        foreach ($items as $itemKey => $item) {
            $curl = $this->makeRequest(self::GRAPH_URI);

            $data = [
                "operationName" => "item",
                "variables" => [
                    "slug" => $item['slug']
                ],
                "query" => file_get_contents(dirname(__DIR__) . '/queries/getItemQuery.txt')
            ];

            $curl->set_opt(CURLOPT_POST, 1);
            $curl->set_opt(CURLOPT_POSTFIELDS, json_encode($data));

            $mc->multi_add($curl->ch, $item, $itemKey);
        }

        $mc->multi_exec(function ($content, $item, $itemKey, $info) use (&$items) {

            $jsonResult = $content;
            if ($info['http_code'] != 200) {
                dd([
                    'ERROR, DOWNLOAD PRODUCT', $info
                ]);
            } else {
                $res = json_decode($jsonResult, 1);

                if(isset($res['errors'])) {
                    $items[$itemKey]['data'] = [
                        'error' => $res,
                        'item' => false
                    ];
                }else {
                    $items[$itemKey]['our_user_id'] = $this->m->getUserIdByOtherId($res['data']['item']['user']['id']);
                    $items[$itemKey]['data'] = $res['data'];
                }
            }
        });

        $parseTestimonialsUsers = [];
        foreach ($items as $item) {
            if(!$item['data']['item'])
                continue;

            if (!$item['our_user_id'])
                $parseTestimonialsUsers[] = $item['data']['item']['user'];
        }

        foreach ($this->getTestimonials($parseTestimonialsUsers) as $account) {
            foreach ($items as $itemKey => $item) {
                if (isset($item['data']['item']['user']['id']) && $item['data']['item']['user']['id'] && $item['data']['item']['user']['id'] == $account['id']) {
                    $item['data']['item']['user']['testimonials'] = $account['data']['testimonials'];
                }
                $items[$itemKey] = $item;
            }
        }

        return $items;
    }

    public function getTestimonials(array $accountsList): array
    {
        $mc = new CURL;
        foreach ($accountsList as $itemKey => $item) {
            $curl = $this->makeRequest(self::GRAPH_URI);

            $data = [
                "operationName" => "testimonials",
                "variables" => [
                    "filter" => [
                        "status" => ['APPROVED'],
                        "userId" => $item['id']
                    ],
                    "pagination" => [
                        "first" => 60
                    ],
                ],
                "query" => file_get_contents(dirname(__DIR__) . '/queries/getTestimonialsQuery.txt')
            ];

            $curl->set_opt(CURLOPT_POST, 1);
            $curl->set_opt(CURLOPT_POSTFIELDS, json_encode($data));

            $mc->multi_add($curl->ch, $item, $itemKey);
        }

        $mc->multi_exec(function ($content, $item, $itemKey, $info) use (&$accountsList) {

            $jsonResult = $content;
            if ($info['http_code'] != 200) {
                dd([
                    'ERROR, DOWNLOAD Testimonials', $info
                ]);
            } else {
                $data = json_decode($jsonResult, 1)['data'];
                $accountsList[$itemKey]['data'] = $data;
            }
        });

        return $accountsList;
    }

    public function downloadImages(array $images, $hideWatermarks = false): bool
    {
        $mc = new CURL;
        foreach ($images as $img) {
            $curl = $this->makeRequest($img['url']);
            $curl->set_opt(CURLOPT_HTTPHEADER, [

            ]);
            $mc->multi_add($curl->ch, $img);
        }

        $mc->multi_exec(function ($content, $img, $info) use ($images, $hideWatermarks) {
            if ($info['http_code'] == 200) {

                file_put_contents($img['savePath'], $content);
                if ((isset($img['hideWatermark']) && $img['hideWatermark']) || ($hideWatermarks && !isset($img['hideWatermark'])))
                    self::hideWatermark($img['savePath'], Config::HIDE_WATERMARK_IMG);
            } else {
                self::deleteImages($images);
                dd([
                    'ERROR DOWNLOAD IMAGE',
                    $info
                ]);
                exit;
            }
        });
        return true;
    }

    private static function hideWatermark($mainImagePath, $shortImagePath)
    {

        $mainImage = imagecreatefromjpeg($mainImagePath);
        $shortImage = imagecreatefrompng($shortImagePath);

// Получение размеров изображений
        $mainWidth = imagesx($mainImage);
        $mainHeight = imagesy($mainImage);
        $shortWidth = imagesx($shortImage);
        $shortHeight = imagesy($shortImage);

// Вычисление координат в пикселях на основе процентов
        $shortX1 = $mainWidth * 82 / 100; // X координата левого верхнего угла
        $shortY1 = $mainHeight * 86 / 100; // Y координата левого верхнего угла
        $shortX2 = $mainWidth * 97 / 100; // X координата правого нижнего угла
        $shortY2 = $mainHeight * 96 / 100; // Y координата правого нижнего угла

// Округляем значения вверх до ближайшего целого числа
        $shortX1 = ceil($shortX1);
        $shortY1 = ceil($shortY1);
        $shortX2 = ceil($shortX2);
        $shortY2 = ceil($shortY2);

// Растягиваем изображение short.png до нужного размера
        $newShortWidth = $shortX2 - $shortX1;
        $newShortHeight = $shortY2 - $shortY1;
        $newShortImage = imagecreatetruecolor($newShortWidth, $newShortHeight);
        imagealphablending($newShortImage, false);
        imagesavealpha($newShortImage, true);
        imagecopyresampled($newShortImage, $shortImage, 0, 0, 0, 0, $newShortWidth, $newShortHeight, $shortWidth, $shortHeight);

// Наложение изображения short.png на main.jpg
        imagecopy($mainImage, $newShortImage, $shortX1, $shortY1, 0, 0, $newShortWidth, $newShortHeight);

// Сохранение измененного main.jpg
        imagejpeg($mainImage, $mainImagePath);

// Освобождаем память
        imagedestroy($mainImage);
        imagedestroy($newShortImage);
        imagedestroy($shortImage);
        return true;
    }

    private static function deleteImages(array $images)
    {
        foreach ($images as $img) {
            if (file_exists($img['savePath']))
                unlink($img['savePath']);
        }
        return true;
    }
}