<?php

require_once __DIR__ . '/Config.php';
require_once __DIR__ . '/library/parser/bootstrap.php';
require_once __DIR__ . '/library/Model.php';
require_once __DIR__ . '/library/API.php';
require_once __DIR__ . '/library/Parser.php';

ini_set('log_errors', true);
ini_set('error_log', __DIR__ . '/php_error.log');

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 60 * 3);
set_time_limit(60 * 3);


const SETTINGS_PATH = __DIR__ . '/UpdateOrCreateItemsSettings.json';
$set = [];
if(file_exists(SETTINGS_PATH))
    $set = json_decode(file_get_contents(SETTINGS_PATH), 1);
else
    $set['after'] = '';

if(Config::CHECK_ONLY_NEW_ITEMS)
    $set['after'] = '';

$p = new Parser();
$api = new API();
$m = new Model();
$result = [];
$result['data']['items']['pageInfo']['hasNextPage'] = true;
$total = 0;
$MAX_PARSE_COUNT = 60;
$errorTimer = 0;
$errors = 0;


//$preTotal = 0;

while ($result['data']['items']['pageInfo']['hasNextPage']) {
//    if($preTotal >= 3)
//        break;
//    $preTotal++;
    try {
        $result = $p->getItems($MAX_PARSE_COUNT, $set['after']);

        if(isset($result['data']['items']['pageInfo']['endCursor'])) {
            $set['after'] = $result['data']['items']['pageInfo']['endCursor'];
        }else {
            $errors++;
            $errorTimer += 15;
            sleep($errorTimer);
            echo "ERRORZ" . PHP_EOL;
            $result['data']['items']['pageInfo']['hasNextPage'] = true;
            continue;
        }

        if (!isset($result['data']))
            return exit('result data error');

        $errorTimer = 0;

        $m->insertShortProducts($result['data']['items']['edges']);

        $total += $MAX_PARSE_COUNT;
        saveSettins();
        echo "ITEMS: $total:" . $result['data']['items']['totalCount'] . " ERRORS: $errors " . PHP_EOL;
    }catch (\Exception $e) {
        $errors++;
        $errorTimer += 5;
        echo PHP_EOL . PHP_EOL;
        echo  $e->getMessage() . PHP_EOL;
        echo PHP_EOL . PHP_EOL;
        sleep($errorTimer);
    }

    if(Config::CHECK_ONLY_NEW_ITEMS)
        break;
}

saveSettins();
function saveSettins() {
    global $set;
    file_put_contents(SETTINGS_PATH, json_encode($set));
    return 1;
}

